﻿using System;
using System.Collections.Generic;

public delegate T BinaryOperation<T>(T x, T y);

public class Utility
{
    public static void GetIntegers(out List<int> a)
    {
        // Read a line of integers from the console into the 
        // list a. Each integer must be separated from the 
        // next by white space or a comma.
        String buffer = Console.ReadLine();
        char[] seps = { '\t', ' ', ',' };
        String[] tokes = buffer.Split(seps);
        a = new List<int>();
        foreach (string token in tokes)
        {
            try
            {
                a.Add(Int32.Parse(token));
            }
            catch (Exception e)
            {
                // Ignore non-integers on the input line.
            }
        }
    }
    public static T Accumulate<T>(T initial, BinaryOperation<T> op,
                                  IEnumerable<T> a)
    {
        T result = initial;
        foreach (T x in a) result = op(result, x);
        return result;
    }
    public static T Accumulate<T>(T initial, BinaryOperation<T> op,
                                  params T[] a)
    {
        return Accumulate<T>(initial, op, (IEnumerable<T>)a);
    }
    public static void shuffle(int[] a, int n,
                               int swapCount)
    {
        Random rnd = new Random();
        for (int count = 1; count <= swapCount; ++count)
        {
            int i = rnd.Next(n), j = rnd.Next(n);
            swap(ref a[i], ref a[j]);
        }
    }
    public unsafe static void unsafeShuffle(int[] a, int n,
                                      int swapCount) {
        Random rnd = new Random();
        fixed (int *p = a) {
            for (int count = 1; count <= swapCount; ++count) {
                int i = rnd.Next(n), j = rnd.Next(n);
                swap(ref p[i], ref p[j]);
            }
        }
    }
    public static void Main()
    {
        decimal sum = Utility.Accumulate(0.0m, (x, y) => x + y,
          2929597524.78m,
          9284729752.89m,
          9857437734.29m
        );
        long product = Utility.Accumulate(1L, (x, y) => x * y,
                                98129L, 8529L, 67L, 874L, 23L);
        string bigString = Utility.Accumulate("", (x, y) => x + y,
            "Fours", "core ", "and ", "seven ", "years ago our ",
            "fathers ", "brought forth on this continent a ",
            "new nation, ", "conceived in ", "liberty and ",
            "founded on the ", "proposition that ", "all men ",
            "are created equal ", "and are endowed by their creator ",
            "with ", "certain inalienable rights."
        );
        Console.WriteLine("Sum is " + sum);
        Console.WriteLine("Product is " + product);
        Console.WriteLine("Big string is \"" + bigString + "\"");
    }
}
